%%----------------------------------------------------------------

%   Product:   Jacket
%   Example:   black_scholes_example
%   Version:   1.2

%   Copyright (c) AccelerEyes LLC. All rights reserved.
%   See http://www.accelereyes.com/doc/EULA.pdf for details.

%   This software is distributed WITHOUT ANY WARRANTY; without even 
%   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
%   PURPOSE.  See the above copyright notices for more information.

%%----------------------------------------------------------------
function [C,P] = black_scholes(S,X,R,V,T)

% This function computes the call and put option prices based on
% Black-Scholes Model

% S = Underlying stock price
% X = Strike Price
% R = Risk free rate of interest
% V = Volatility
% T = Time to maturity

  d1 = log (S ./ X);
  d1 = d1 + (R + (V.*V)*0.5) .* T;
  d1 = d1./(V.*sqrt(T));

  d2 = d1 - (V.*sqrt(T));

  C = S .* cnd(d1)  - (X .* exp(-R.*T) .* cnd(d2));

  P = X .* exp(-R.*T) .* cnd(-d2) - (S .* cnd(-d1));

end

function y = cnd(x)
% This function computes the probability that a variable will be less
% than x standard deviations  

  temp = (x>0);
  y = temp .* (0.5 + erf(x/sqrt(2))/2) + (1-temp) .* (0.5 - erf(-x/sqrt(2))/2);

end
