%% MASTER SCRIPT FOR GFLOPS COUNT

% IMPORTANT NOTE:  The name of the benchmark file MUST be like:
%                  Name_FCT.m where FCT is the name of the function
%                  to be benchmarked (all capital letters) - e.g. BESSELJ.
%                  A full name could be: AsusG51J_BESSELJ.m or
%                  Asus_G51J_BESSELJ.
%
% Platform:        Asus G51J
% CPU:             Intel Core i7-720QM 1.6GHz
% CPU GFlops:      25.6 (http://www.intel.com/support/processors/sb/cs-023143.htm)
% CPU mem.:        4 GB
% GPU:             NVIDIA GTX260M
% GPU GFlops:      462 (http://www.nvidia.com/object/product_geforce_gtx_260m_us.html)
% GPU mem.:        1024 MB
% Operating sys.:  Microsoft Windows 7 x64
% Jacket ver.:     1.4.0 (build 6080)
% NVIDIA driver:   257.21
% CUDA Toolkit:    3.1

%% SET UP INPUT DATA
% Set number of threads to 1
maxNumCompThreads(1);

% Matrix size
Size = [2:1:1271];

% Core name of plot and data files
Fname = 'Asus_G51J_01';
Dname = './Asus.GTX260M';

% Name of title in plot
TitleStr = 'Asus G51J: Core i7-720QM (25.6 GFlops) & GTX260M (462 GFlops)';

% Computation type;
%   State = 'BENCH' for cold start
%   State = 'RESUME' for continuation of computations
State = 'BENCH';

% Perform computation
flopsMx20( Size, Dname, Fname, TitleStr, State );
