<?php
/**
 * Internationalisation file for extension SyntaxHighlight.
 *
 * @addtogroup Extensions
*/

$messages = array();

/** English
 * @author Brion Vibber
 */
$messages['en'] = array(
	'syntaxhighlight-desc'         => 'Provides syntax highlighting <tt><nowiki><source></nowiki></tt> using [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'You need to specify a language like this:',
	'syntaxhighlight-supported'    => 'Supported languages for syntax highlighting:',
	'syntaxhighlight-err-loading'  => '(error loading supported language list)',
	'syntaxhighlight-err-language' => 'Invalid language.',
	'geshi.css'                    => '/* CSS placed here will be applied to GeSHi syntax highlighting */',
);

/** Afrikaans (Afrikaans)
 * @author SPQRobin
 */
$messages['af'] = array(
	'syntaxhighlight-err-language' => 'Ongeldige taal.',
);

/** Aragonese (Aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'syntaxhighlight-desc'         => 'Premite o resalte sintactico <tt><nowiki><source></nowiki></tt> usando [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => "Ha d'endicar un lenguache asinas:",
	'syntaxhighlight-supported'    => 'Lenguaches suportatos ta o resalte sintactico:',
	'syntaxhighlight-err-loading'  => '(error cargando a lista de lenguaches suportatos)',
	'syntaxhighlight-err-language' => 'Lenguache incorreuto.',
	'geshi.css'                    => "/* Iste codigo CSS s'aplicará ta destacar a sintacsis GeSHi*/",
);

/** Arabic (العربية)
 * @author Meno25
 */
$messages['ar'] = array(
	'syntaxhighlight-desc'         => 'يوفر تعليم النص <tt><nowiki><source></nowiki></tt> باستخدام [http://qbnz.com/highlighter/ معلم GeSHi]',
	'syntaxhighlight-specify'      => 'يجب عليك تحديد لغة مثل هذه:',
	'syntaxhighlight-supported'    => 'اللغات المدعومة لتظليل الصياغة:',
	'syntaxhighlight-err-loading'  => '(خطأ في تحميل قائمة اللغات المدعومة)',
	'syntaxhighlight-err-language' => 'لغة غير صحيحة.',
	'geshi.css'                    => '/* الأنماط المتراصة CSS المعروضة هنا ستطبق على GeSHi syntax highlighting */',
);

/** Asturian (Asturianu)
 * @author Esbardu
 */
$messages['ast'] = array(
	'syntaxhighlight-specify'      => 'Necesites conseñar una llingua como esta:',
	'syntaxhighlight-supported'    => 'Llingües sofitaes pa la sintaxis en colores:',
	'syntaxhighlight-err-loading'  => '(error al cargar la llista de llingües sofitaes)',
	'syntaxhighlight-err-language' => 'Llingua non válida.',
	'geshi.css'                    => '/* El códigu CSS allugáu equí va ser aplicáu por GeSHi pa la sintaxis en colores */',
);

/** Southern Balochi (بلوچی مکرانی)
 * @author Mostafadaneshvar
 */
$messages['bcc'] = array(
	'syntaxhighlight-desc'         => 'ساختار پررنگی آریت <tt><nowiki><source></nowiki></tt> گون استفاده چه[http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'لازمنت شما یک زبانی په داب شی مشخض کنیت:',
	'syntaxhighlight-supported'    => 'حمایتی زبانان په ساختار پررنگی:',
	'syntaxhighlight-err-loading'  => '(حطا ته بار کتن لیست زبان داشتگین)',
	'syntaxhighlight-err-language' => 'نامعتبرین زبان',
	'geshi.css'                    => '/* CSS که ادان هستن ته ساختار جی شی پررنگ کتن کارمرز بین */',
);

/** Bulgarian (Български)
 * @author Borislav
 * @author DCLXVI
 */
$messages['bg'] = array(
	'syntaxhighlight-specify'      => 'Нужно е да укажете език по следния начин:',
	'syntaxhighlight-supported'    => 'Поддържани езици за синтактично открояване:',
	'syntaxhighlight-err-loading'  => '(грешка при зареждането на списъка на поддържаните езици)',
	'syntaxhighlight-err-language' => 'Невалиден език.',
	'geshi.css'                    => '/* Евентуален код на CSS, поставен тук, ще бъде използван за синтактичното открояване чрез GeSHi */',
);

/** Bengali (বাংলা)
 * @author Zaheen
 */
$messages['bn'] = array(
	'syntaxhighlight-desc'         => '[http://qbnz.com/highlighter/ GeSHi হাইলাইটার] ব্যবহার করে <tt><nowiki><source></nowiki></tt> সিনট্যাক্স হাইলাইটিং-এর ক্ষমতা দেয়',
	'syntaxhighlight-specify'      => 'আপনাকে এভাবে একটি ভাষা নির্দিষ্ট করতে হবে:',
	'syntaxhighlight-supported'    => 'যেসব ভাষার জন্য সিনট্যাক্স হাইলাইটিং সমর্থিত:',
	'syntaxhighlight-err-loading'  => '(সমর্থিত ভাষার তালিকা আনতে ত্রুটি)',
	'syntaxhighlight-err-language' => 'অবৈধ ভাষা।',
	'geshi.css'                    => '/* এখানে স্থাপিত CSS কোড GeSHi সিনট্যাক্স হাইলাইটিং-এ ব্যবহার করা হবে */',
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'syntaxhighlight-specify'      => "Ret eo deoc'h spisaat ur yezh evel-henn :",
	'syntaxhighlight-err-language' => 'Yezh direizh.',
);

/** Catalan (Català)
 * @author SMP
 */
$messages['ca'] = array(
	'syntaxhighlight-specify'      => "Heu d'especificar un dels llenguatges:",
	'syntaxhighlight-supported'    => 'Llenguatges admesos per al ressaltament sintàctic:',
	'syntaxhighlight-err-loading'  => '(error en carregar la llista de llenguatges)',
	'syntaxhighlight-err-language' => 'Llenguatge invàlid.',
);

/** Czech (Česky)
 * @author Li-sung
 * @author Matěj Grabovský
 */
$messages['cs'] = array(
	'syntaxhighlight-desc'         => 'Poskytuje zvýrazňování syntaxe <tt>&lt;source&gt;</tt> pomocí [http://qnbz.com/higlighter zvýrazňovače GeSHi]',
	'syntaxhighlight-specify'      => 'Musíte určit jazyk tímto způsobem:',
	'syntaxhighlight-supported'    => 'Seznam jazyků, u kterých je podporováno zvýrazňování syntaxe:',
	'syntaxhighlight-err-loading'  => '(chyba při načítání seznamu podporovaných jazyků)',
	'syntaxhighlight-err-language' => 'Neplatný jazyk.',
	'geshi.css'                    => '/* Zde uvedené CSS bude ovlivňovat zvýrazňování syntaxe GeSHi */',
);

/** German (Deutsch)
 * @author Raimond Spekking
 */
$messages['de'] = array(
	'syntaxhighlight-desc'         => 'Syntax-Hervorhebung <tt><nowiki><source></nowiki></tt> mit Hilfe des [http://qbnz.com/highlighter/ GeSHi-Highlighters]',
	'syntaxhighlight-specify'      => 'Die gewünschte Sprache muss wie folgt definiert werden:',
	'syntaxhighlight-supported'    => 'Unterstützte Sprachen für die Syntax-Hervorhebung:',
	'syntaxhighlight-err-loading'  => '(Fehler beim Laden der Sprachenliste)',
	'syntaxhighlight-err-language' => 'Ungültige Sprache.',
	'geshi.css'                    => '/* CSS in dieser MediaWiki-Systemnachricht wird auf die GeSHi-Syntaxhervorhebung angewendet */',
);

/** Greek (Ελληνικά)
 * @author ZaDiak
 * @author Badseed
 * @author Consta
 */
$messages['el'] = array(
	'syntaxhighlight-specify'      => 'Πρέπει να επιλέξετε μια γλώσσα σαν κι αυτήν:',
	'syntaxhighlight-supported'    => 'Υποστηριζόμενες γλώσσες για επισημάνσεις συντακτικού',
	'syntaxhighlight-err-loading'  => '(λάθος στη φόρτωση της λίστας των υποστηριζόμενων γλωσσών)',
	'syntaxhighlight-err-language' => 'Άκυρη γλώσσα.',
);

/** Esperanto (Esperanto)
 * @author Yekrats
 */
$messages['eo'] = array(
	'syntaxhighlight-desc'         => 'Provizas kolorigado de sintakso <tt><nowiki><source></nowiki></tt> per [http://qbnz.com/highlighter/ GeSHi Kolorigilo de Sintakso]',
	'syntaxhighlight-specify'      => 'Vi nepre specifigu lingvon ĉi tiel:',
	'syntaxhighlight-supported'    => 'Subtenaj lingvoj por sintaksa emfazo',
	'syntaxhighlight-err-loading'  => '(eraro ŝarĝante subtenitan lingvo-liston)',
	'syntaxhighlight-err-language' => 'Nevalida lingvo.',
	'geshi.css'                    => '/* CSS enigita ĉi tie estos sintakse emfazita de GeSHi */',
);

/** Estonian (Eesti)
 * @author [[et:Kasutaja:M2s17]]
 */
$messages['et'] = array(
	'syntaxhighlight-specify'      => 'Sa pead täpsustama keelt nõnda:',
	'syntaxhighlight-supported'    => 'Süntaksi esiletoomise on toetatud järgnevates keeltes:',
	'syntaxhighlight-err-loading'  => '(toetatud keelte loetelu laadimisel esines viga)',
	'syntaxhighlight-err-language' => 'antud keel on mittekehtiv',
	'geshi.css'                    => '/* CSS mis on asetatud siia, määrab GeSHi süntaksi esiletoomise stiili */',
);

/** Basque (Euskara)
 * @author SPQRobin
 */
$messages['eu'] = array(
	'syntaxhighlight-err-language' => 'Baliogabeko hizkuntza.',
);

/** Persian (فارسی)
 * @author Huji
 */
$messages['fa'] = array(
	'syntaxhighlight-desc'         => 'امکان رنگین کردن دستورات <tt><nowiki><source></nowiki></tt> با استفاده از [http://qbnz.com/highlighter/ GeSHi Highlighter] را فراهم می‌آورد',
	'syntaxhighlight-specify'      => 'شما باید به این شکل زبانی را مشخص کنید:',
	'syntaxhighlight-supported'    => 'زبان‌های پشتیبانی‌شده برای رنگین‌کردن دستورات:',
	'syntaxhighlight-err-loading'  => '(خطا در بارگذاری فهرست زبان‌های پشتیبانی‌شده)',
	'syntaxhighlight-err-language' => 'زبان غیرمجاز.',
	'geshi.css'                    => '/* دستورات CSS این‌جا توسط سامانه رنگین‌کردن دستورات GeSHi به کار گرفته می‌شوند */',
);

/** Finnish (Suomi)
 * @author Nike
 */
$messages['fi'] = array(
	'syntaxhighlight-desc'         => 'Mahdollistaa syntaksin korostuksen GeSHillä <nowiki><source></nowiki>-elementtiä käyttämällä.',
	'syntaxhighlight-specify'      => 'Kieli pitää määritellä seuraavasti:',
	'syntaxhighlight-supported'    => 'Syntaksinkorostus on mahdollista seuraaville kielille:',
	'syntaxhighlight-err-loading'  => '(tuettujen kielten luettelon lataaminen epäonnistui)',
	'syntaxhighlight-err-language' => 'Kelpaamaton kieli.',
	'geshi.css'                    => '/* Tänne lisätty CSS vaikuttaa GeSHi-syntaksinkorostukseen */',
);

/** French (Français)
 * @author Sherbrooke
 * @author Grondin
 */
$messages['fr'] = array(
	'syntaxhighlight-desc'         => 'Fournit la mise en relief de la syntaxe par la balise <tt><nowiki><source></nowiki></tt> en utilisant [http://qbnz.com/highlighter/ la coloration syntaxique GeSHi]',
	'syntaxhighlight-specify'      => 'Vous devez spécifier un langage comme ceci :',
	'syntaxhighlight-supported'    => 'Langages supportés pour la coloration syntaxique :',
	'syntaxhighlight-err-loading'  => '(erreur en chargeant la liste des langages supportés)',
	'syntaxhighlight-err-language' => 'Langage invalide',
	'geshi.css'                    => '/* Le code CSS inséré ici sera appliqué par GeSHi pour la coloration syntaxique. */',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'syntaxhighlight-desc'         => 'Fornét la misa en relièf de la sintaxa per la balisa <tt><nowiki><source></nowiki></tt> en utilisent [http://qbnz.com/highlighter/ la coloracion sintaxica GeSHi].',
	'syntaxhighlight-specify'      => 'Vos dête spècefiar un lengâjo d’ense :',
	'syntaxhighlight-supported'    => 'Lengâjos sotegnus por la coloracion sintaxica :',
	'syntaxhighlight-err-loading'  => '(èrror en chargient la lista des lengâjos sotegnus)',
	'syntaxhighlight-err-language' => 'Lengâjo envalido',
	'geshi.css'                    => '/* Lo CSS placiê ique serat aplicâ per GeSHi por la coloracion sintaxica. */',
);

/** Galician (Galego)
 * @author Xosé
 * @author Toliño
 */
$messages['gl'] = array(
	'syntaxhighlight-desc'         => 'Proporciona unha sintaxe resaltada <tt><nowiki><source></nowiki></tt> usando [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Ten que especificar unha linguaxe así:',
	'syntaxhighlight-supported'    => 'Linguaxes coñecidas para resaltar a sintaxe:',
	'syntaxhighlight-err-loading'  => '(erro ao cargar a listaxe de linguaxes coñecidas)',
	'syntaxhighlight-err-language' => 'Linguaxe non válida.',
	'geshi.css'                    => '/* O CSS colocado aquí será aplicado ao resalte da sintaxe de GeSHi */',
);

/** Hebrew (עברית)
 * @author Rotem Liss
 */
$messages['he'] = array(
	'syntaxhighlight-desc'         => 'אפשרות לסימון קוד מקור בצבעים עם התגית <tt><nowiki><source></nowiki></tt> באמצעות [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'עליכם לציין שפה באופן הבא:',
	'syntaxhighlight-supported'    => 'שפות נתמכות:',
	'syntaxhighlight-err-loading'  => '(שגיאה בטעינת הרשימה של השפות הנתמכות)',
	'syntaxhighlight-err-language' => 'שפה שגויה.',
	'geshi.css'                    => '/* סגנונות CSS שייכתבו כאן יפעלו על התגית source */',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 * @author Shyam
 */
$messages['hi'] = array(
	'syntaxhighlight-desc'         => '[http://qbnz.com/highlighter/ GeSHi Highlighter] प्रयोग करके चिन्हांकित <tt><nowiki><source></nowiki></tt> वाक्य विश्लेषण उपलब्ध करता है',
	'syntaxhighlight-specify'      => 'आपने इसप्रकार भाषा देना जरूरी हैं:',
	'syntaxhighlight-supported'    => 'सिन्टॅक्स हायलायटींग निम्नलिखित भाषाओंके लिये उपलब्ध हैं:',
	'syntaxhighlight-err-loading'  => '(सपोर्टेड भाषाओंकी सूची नहीं दर्शा पा रहें हैं)',
	'syntaxhighlight-err-language' => 'अवैध भाषा।',
	'geshi.css'                    => '/* यहाँ पर उपस्थित CSS GeSHi चिन्हांकित वाक्य विश्लेषण पर प्रयोग किए जायेंगे */',
);

/** Croatian (Hrvatski)
 * @author SpeedyGonsales
 * @author Dalibor Bosits
 */
$messages['hr'] = array(
	'syntaxhighlight-desc'         => 'Omogućava bojanje sintakse <tt><nowiki><source></nowiki></tt> korištenjem [http://qbnz.com/highlighter/ GeSHi Highlighter-a]',
	'syntaxhighlight-specify'      => 'Molimo navedite jezik na slijedeći način:',
	'syntaxhighlight-supported'    => 'Jezici podržani za bojanje sintakse:',
	'syntaxhighlight-err-loading'  => '(greška pri učitavanju popisa podržanih jezika)',
	'syntaxhighlight-err-language' => 'Nevaljani jezik.',
	'geshi.css'                    => '/* CSS kod napisan ovdje će biti primijenjen na GeSHi bojanje sintakse */',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'syntaxhighlight-desc'         => 'Syntaksowe wuzběhnjenje <tt><nowiki><source></nowiki></tt> z pomocu rozšěrjenja [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Dyrbiš rěč takle definować:',
	'syntaxhighlight-supported'    => 'Podpěrowane rěče za syntaksowe wuzběhnjenje:',
	'syntaxhighlight-err-loading'  => '(Zmylk při začitanju lisćiny rěčow)',
	'syntaxhighlight-err-language' => 'Njepłaćiwa rěč.',
	'geshi.css'                    => '/* CSS w tutej zdźělence so na syntaksowe wuzběhnjenje GeSHi nałoži */',
);

/** Hungarian (Magyar)
 * @author Dani
 */
$messages['hu'] = array(
	'syntaxhighlight-desc'         => 'Lehetőséget nyújt szintaxiskiemelésre a <tt><nowiki><source></nowiki></tt> tag-gel, a [http://qbnz.com/highlighter/ GeSHi Highlighter] használatával',
	'syntaxhighlight-specify'      => 'Meg kell adnod egy nyelvet az alábbi módon:',
	'syntaxhighlight-supported'    => 'Támogatott programozási nyelvek:',
	'syntaxhighlight-err-loading'  => '(hiba történt a támogatott nyelvek listájának betöltése közben)',
	'syntaxhighlight-err-language' => 'Érvénytelen nyelv.',
	'geshi.css'                    => '/* Az itt elhelyezett CSS-t fogja alkalmazni a GeSHi szintaxiskiemelő */',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'syntaxhighlight-desc'         => 'Forni le emphase visual syntactic in <tt><nowiki><source></nowiki></tt> per medio de [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Tu debe specificar un linguage in iste modo:',
	'syntaxhighlight-supported'    => 'Linguages supportate pro le emphase visual syntactic:',
	'syntaxhighlight-err-loading'  => '(error durante le cargamento del lista de linguages supportate)',
	'syntaxhighlight-err-language' => 'Linguage invalide.',
	'geshi.css'                    => '/* Omne CSS inserite hic se applicara al emphase visual syntactic con GeSHi */',
);

/** Indonesian (Bahasa Indonesia)
 * @author IvanLanin
 */
$messages['id'] = array(
	'syntaxhighlight-desc'         => 'Memberikan penyorotan sintaks <tt><nowiki><source></nowiki></tt> menggunakan [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Anda harus menentukan suatu bahasa seperti ini:',
	'syntaxhighlight-supported'    => 'Bahasa-bahasa yang didukung oleh pewarnaan sintaks:',
	'syntaxhighlight-err-loading'  => '(kesalahan pemuatan daftar bahasa yang didukung)',
	'syntaxhighlight-err-language' => 'Bahasa tak sah.',
	'geshi.css'                    => '/* CSS di sini akan diterapkan untuk penyorotan sintaks GeSHi */',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'syntaxhighlight-err-language' => 'Ne-valida linguo.',
);

/** Italian (Italiano)
 * @author BrokenArrow
 */
$messages['it'] = array(
	'syntaxhighlight-desc'         => 'Evidenzia la sintassi dei linguaggi di programmazione <tt><nowiki><source></nowiki></tt> tramite [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'È necessario specificare un linguaggio in questo modo:',
	'syntaxhighlight-supported'    => 'Linguaggi di cui è possibile evidenziare la sintassi in colore:',
	'syntaxhighlight-err-loading'  => "(errore nel caricamento dell'elenco dei linguaggi supportati)",
	'syntaxhighlight-err-language' => 'Linguaggio non riconosciuto.',
	'geshi.css'                    => "/* Gli stili CSS inseriti qui si applicano all'evidenziazione di sintassi con GeSHi */",
);

/** Japanese (日本語)
 * @author JtFuruhata
 */
$messages['ja'] = array(
	'syntaxhighlight-desc'         => '[http://qbnz.com/highlighter/ GeSHi 構文ハイライト機能] を利用したタグ <tt><nowiki><source></nowiki></tt> を提供する',
	'syntaxhighlight-specify'      => '以下のように言語を指定する必要があります:',
	'syntaxhighlight-supported'    => '構文ハイライト機能に対応している言語は以下の通りです:',
	'syntaxhighlight-err-loading'  => '（対応言語のロード時にエラーが発生しました）',
	'syntaxhighlight-err-language' => '不正な言語名です。',
	'geshi.css'                    => '/* ここへ、GeShi 構文ハイライト機能に適用する CSS を記述してください */',
);

/** Jutish (Jysk)
 * @author Huslåke
 * @author Ælsån
 */
$messages['jut'] = array(
	'syntaxhighlight-desc'         => 'Gäv syntaks highlighting <tt><nowiki><source></nowiki></tt> via [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Du nødst til spæsifiær en språg als dette:',
	'syntaxhighlight-supported'    => 'Understønde språg før syntaks highlighting:',
	'syntaxhighlight-err-loading'  => '(fejl lægende understønde språg liste)',
	'syntaxhighlight-err-language' => 'Fejl språg.',
	'geshi.css'                    => '/* CSS platsk her hvil være appliærn til GeSHi syntaks highlighting */',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 */
$messages['jv'] = array(
	'syntaxhighlight-desc'         => 'Mènèhaké panyorotan sintaksis <tt><nowiki><source></nowiki></tt> nganggo [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Panjenengan kudu nentokaké sawijining basa kaya iki:',
	'syntaxhighlight-supported'    => 'Basa-basa sing disengkuyung déning panandhan werna sintaksis:',
	'syntaxhighlight-err-loading'  => '(ana kaluputan ngunggahaké daftar basa sing disengkuyung)',
	'syntaxhighlight-err-language' => 'Basané ora absah.',
	'geshi.css'                    => '/* CSS ing kéné bakal ditrapaké kanggo panyorotan sintaksis GeSHi */',
);

/** Kazakh (Arabic script) (‫قازاقشا (تٴوتە)‬)
 * @author AlefZet
 */
$messages['kk-arab'] = array(
	'syntaxhighlight-specify'      => 'ٴتىلدى بىلايشا كورسەتۋىڭىز قاجەت:',
	'syntaxhighlight-supported'    => 'سىينتاكسىيسى كومەسكى جارىقتالاتىن سۇيەمەلدەنگەن تىلدەر:',
	'syntaxhighlight-err-loading'  => '(سۇيەمەلدەنگەن تىلدەر ٴتىزىمىن جۇكتەۋ قاتەسى)',
	'syntaxhighlight-err-language' => 'جارامسىز ٴتىل.',
	'geshi.css'                    => '/* مىنداعى CSS امىرلەرى GeSHi سىينتاكسىيستى كومەسكى جارىقتاۋعا قولدانىلادى */',
);

/** Kazakh (Cyrillic) (Қазақша (Cyrillic))
 * @author AlefZet
 */
$messages['kk-cyrl'] = array(
	'syntaxhighlight-specify'      => 'Тілді былайша көрсетуіңіз қажет:',
	'syntaxhighlight-supported'    => 'Синтаксисі көмескі жарықталатын сүйемелденген тілдер:',
	'syntaxhighlight-err-loading'  => '(сүйемелденген тілдер тізімін жүктеу қатесі)',
	'syntaxhighlight-err-language' => 'Жарамсыз тіл.',
	'geshi.css'                    => '/* Мындағы CSS әмірлері GeSHi синтаксисті көмескі жарықтауға қолданылады */',
);

/** Kazakh (Latin) (Қазақша (Latin))
 * @author AlefZet
 */
$messages['kk-latn'] = array(
	'syntaxhighlight-specify'      => 'Tildi bılaýşa körsetwiñiz qajet:',
	'syntaxhighlight-supported'    => 'Sïntaksïsi kömeski jarıqtalatın süýemeldengen tilder:',
	'syntaxhighlight-err-loading'  => '(süýemeldengen tilder tizimin jüktew qatesi)',
	'syntaxhighlight-err-language' => 'Jaramsız til.',
	'geshi.css'                    => '/* Mındağı CSS ämirleri GeSHi sïntaksïsti kömeski jarıqtawğa qoldanıladı */',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Chhorran
 */
$messages['km'] = array(
	'syntaxhighlight-specify'      => 'អ្នកចាំបាច់ សំដៅ មួយភាសា ដូច នេះ ៖',
	'syntaxhighlight-err-language' => 'ភាសា គ្មានសុពលភាព ។',
);

/** Korean (한국어)
 * @author ToePeu
 */
$messages['ko'] = array(
	'syntaxhighlight-desc'         => '<tt><nowiki><source></nowiki></tt> 태그로 [http://qbnz.com/highlighter/ GeSHi Highlighter]를 이용해 문법 강조 기능을 지원합니다.',
	'syntaxhighlight-specify'      => '오른쪽과 같이 언어를 설정해야 합니다:',
	'syntaxhighlight-supported'    => '문법 강조가 지원되는 언어 목록',
	'syntaxhighlight-err-language' => '잘못된 언어 설정입니다.',
	'geshi.css'                    => '/* 이 문서에서 설정한 CSS는 GeSHi에 적용됩니다. */',
);

/** Ripoarisch (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'syntaxhighlight-desc'         => 'Deijt — en <tt><nowiki><source></nowiki></tt>-Affschnedde — de Syntax fon beshtemmpte Computer-Shprooche makeere. Bruch dobei dä [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Mer moß en Shprooch aanjevve, esu en dä Aat wi hee:',
	'syntaxhighlight-supported'    => 'Di Shprooche, dänne ier Syntax mer makeere könne, sin:',
	'syntaxhighlight-err-loading'  => '(Enne Fääler es opjetrodde, wi mer de Leß met de Shprooch laade wollte)',
	'syntaxhighlight-err-language' => 'Di Shprooch kenne mer nit.',
	'geshi.css'                    => '/* Dat es dat CCS för de Afschnedde med däm GeSHi syntax highlighting */',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'syntaxhighlight-desc'         => "Syntax-Ervirhiewung <tt><nowiki><source></nowiki></tt> mat Hellëf vu [http://qbnz.com/highlighter/ 'GeSHi Highlighter']",
	'syntaxhighlight-specify'      => 'Déi gewënschte Sprooch muss esou definéiert ginn:',
	'syntaxhighlight-supported'    => "Ënnerstetzte Sproochen fir d'Syntax faarweg ze markéieren",
	'syntaxhighlight-err-loading'  => '(Feeler beim Luede vun der Lëscht vun den ënnerstetzte Sproochen)',
	'syntaxhighlight-err-language' => 'Ongëlteg Sprooch',
	'geshi.css'                    => "/* Den CSS deen hei steet gëtt benotzt fir d'GeSHi Syntax faarweg ze markéieren. /*",
);

/** Limburgish (Limburgs)
 * @author Ooswesthoesbes
 */
$messages['li'] = array(
	'syntaxhighlight-desc'         => 'Guf syntaxismarkering <tt><nowiki><source></nowiki></tt> gebroekende [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => "Gaef 'ne taal es volg op:",
	'syntaxhighlight-supported'    => 'Óngersteunde täöl veur syntaxismarkering:',
	'syntaxhighlight-err-loading'  => "(fout bie 't laje vanne lies mit óngersteunde täöl)",
	'syntaxhighlight-err-language' => 'Ónzjuuste taal.',
	'geshi.css'                    => '/* Hiej geplaatste CBBS wuuertj toegepas op GeSHo syntax markering */',
);

/** Lithuanian (Lietuvių)
 * @author Garas
 * @author Matasg
 */
$messages['lt'] = array(
	'syntaxhighlight-specify'      => 'Jums reikia nurodyti kalbą kaip čia:',
	'syntaxhighlight-supported'    => 'Palaikomos kalbos sintaksės paryškinimui:',
	'syntaxhighlight-err-loading'  => '(klaida įkeliant palaikomų kalbų sąrašą)',
	'syntaxhighlight-err-language' => 'Neleistina kalba.',
);

/** Malayalam (മലയാളം)
 * @author Shijualex
 */
$messages['ml'] = array(
	'syntaxhighlight-specify'      => 'താങ്കള്‍ ഇപ്രകാരം ഒരു ഭാഷ തിരഞ്ഞെടുക്കണം:',
	'syntaxhighlight-supported'    => 'സിറ്റാക്സ് ഹൈലൈറ്റിങ്ങ് അനുകൂലിക്കുന്ന ഭാഷകള്‍:',
	'syntaxhighlight-err-loading'  => '(ഭാഷകളുടെ പട്ടിക ലോഡ് ചെയ്യുന്നതില്‍ പിശക്)',
	'syntaxhighlight-err-language' => 'അസാധുവായ ഭാഷ.',
);

/** Marathi (मराठी)
 * @author Kaustubh
 * @author Mahitgar
 */
$messages['mr'] = array(
	'syntaxhighlight-desc'         => '[http://qbnz.com/highlighter/ GeSHi हायलायटर] वापरून सिन्टॅक्स हायलाईट करा <tt><nowiki><source></nowiki></tt>',
	'syntaxhighlight-specify'      => 'तुम्ही याप्रमाणे भाषा देणे गरजेचे आहे:',
	'syntaxhighlight-supported'    => 'सिन्टॅक्स हायलायटींग खालील भाषांवर वापरता येते:',
	'syntaxhighlight-err-loading'  => '(सहाय्य देणार्‍या भाषांची यादी दाखविण्यास असमर्थ)',
	'syntaxhighlight-err-language' => 'गैरलागू भाषा',
	'geshi.css'                    => '/* इथे लिहिलेले CSS GeSHi सिन्टॅक्स हायलायटींग साठी वापरले जाईल */',
);

/** Malay (Bahasa Melayu)
 * @author Aviator
 */
$messages['ms'] = array(
	'syntaxhighlight-desc'         => 'Menyediakan tag <tt><nowiki><source></nowiki></tt> untuk penonjolan sintaks menggunakan [http://qbnz.com/highlighter/ GeSHi]',
	'syntaxhighlight-specify'      => 'Anda hendaklah menyatakan bahasa seperti ini:',
	'syntaxhighlight-supported'    => 'Bahasa-bahasa yang disokong untuk penonjolan sintaks:',
	'syntaxhighlight-err-loading'  => '(berlaku ralat ketika memuat senarai bahasa yang disokong)',
	'syntaxhighlight-err-language' => 'Bahasa tidak sah.',
	'geshi.css'                    => '/* CSS yang diletakkan di sini akan dikenakan kepada penonjolan sintaks GeSHi */',
);

/** Low German (Plattdüütsch)
 * @author Slomox
 */
$messages['nds'] = array(
	'syntaxhighlight-specify'      => 'Du musst op disse Wies en Spraak angeven:',
	'syntaxhighlight-supported'    => 'Ünnerstütt Spraken för dat Syntax-Rutheven:',
	'syntaxhighlight-err-loading'  => '(Fehler bi dat Laden vun de Sprakenlist)',
	'syntaxhighlight-err-language' => 'Spraak gellt nich.',
	'geshi.css'                    => '/* CSS in disse MediaWiki-Systemnaricht warrt för dat GeSHi-Syntaxrutheven bruukt */',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'syntaxhighlight-desc'         => 'Voorziet in het markeren van syntaxis voor <tt><nowiki><source></nowiki></tt> met [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Geef een taal als volgt op:',
	'syntaxhighlight-supported'    => 'Ondersteunde talen voor syntaxismarkering:',
	'syntaxhighlight-err-loading'  => '(fout bij het laden van de lijst met ondersteunde talen)',
	'syntaxhighlight-err-language' => 'Onjuiste taal.',
	'geshi.css'                    => '/* Hier geplaatste CSS wordt toegepast op GeSHi syntax highlighting */',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 */
$messages['no'] = array(
	'syntaxhighlight-desc'         => 'Gir syntaks som framhever <tt><nowiki><source></nowiki></tt> ved hjelp av [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Du må angi et språk slik:',
	'syntaxhighlight-supported'    => 'Støttede språk for syntaksutheving:',
	'syntaxhighlight-err-loading'  => '(feil under last av liste over støttede språk)',
	'syntaxhighlight-err-language' => 'Ugyldig språk.',
	'geshi.css'                    => '/* CSS plassert her gjelder GeSHi syntaksutheving */',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'syntaxhighlight-desc'         => 'Provesís la mesa en relèu de la sintaxi per la balisa <tt><nowiki><source></nowiki></tt> en utilizant [http://qbnz.com/highlighter/ la coloracion sintaxica GeSHi]',
	'syntaxhighlight-specify'      => 'Vos cal especificar un lengatge coma aquò :',
	'syntaxhighlight-supported'    => 'Lengatges suportats per la coloracion sintaxica :',
	'syntaxhighlight-err-loading'  => '(error en cargant la lista dels lengatges suportats)',
	'syntaxhighlight-err-language' => 'Lengatge invalid.',
	'geshi.css'                    => '/* Lo còde CSS inserit aicí serà aplicat per GeSHi per la coloracion sintaxica. */',
);

/** Polish (Polski)
 * @author Derbeth
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'syntaxhighlight-desc'         => 'Zapewnia kolorowanie składni dla znacznika <tt><nowiki><source></nowiki></tt> wykorzystując [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Musisz wybrać język w następujący sposób:',
	'syntaxhighlight-supported'    => 'Języki obsługiwane w podświetlaniu składni:',
	'syntaxhighlight-err-loading'  => '(błąd przy wczytywaniu listy obsługiwanych języków)',
	'syntaxhighlight-err-language' => 'Niepoprawny język.',
	'geshi.css'                    => '/* CSS umieszczony tutaj zostanie użyty do kolorowania składni GeSHi  */',
);

/** Piedmontese (Piemontèis)
 * @author Bèrto 'd Sèra
 */
$messages['pms'] = array(
	'syntaxhighlight-specify'      => 'A venta specifiché na lenga coma:',
	'syntaxhighlight-supported'    => "Lenghe dont as peul fé l'evidensiassion dla sintassi:",
	'syntaxhighlight-err-loading'  => '(eror ën cariand la lista dle lenghe dont sintassi as peul evidensié)',
	'syntaxhighlight-err-language' => 'Lenga nen bon-a',
	'geshi.css'                    => "/* ël CSS piassà ambelessì a sarà aplicà a l'evidensiassion ëd sintassi GeSHi */",
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'syntaxhighlight-specify'      => 'تاسو ته پکار ده چې يوه ژبه په دې توګه ځانګړې کړی:',
	'syntaxhighlight-err-language' => 'ناسمه ژبه.',
);

/** Portuguese (Português)
 * @author Malafaya
 */
$messages['pt'] = array(
	'syntaxhighlight-desc'         => 'Providencia <tt><nowiki><source></nowiki></tt> de sinalização de sintaxe  através do [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Você precisa especificar uma linguagem, tal como:',
	'syntaxhighlight-supported'    => 'Linguagens suportadas no realce de sintaxe:',
	'syntaxhighlight-err-loading'  => '(erro ao carregar a lista de linguagens suportadas)',
	'syntaxhighlight-err-language' => 'Linguagem inválida.',
	'geshi.css'                    => '/* O código CSS aqui colocado será aplicado ao realce de sintaxe GeSHi */',
);

/** Russian (Русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'syntaxhighlight-desc'         => 'Позволяет использовать тег <tt><nowiki><source></nowiki></tt> для подсветки синтаксиса с помощью [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Вы должны указать язык следующим образом:',
	'syntaxhighlight-supported'    => 'Поддерживаемые языки:',
	'syntaxhighlight-err-loading'  => '(невозможно загрузить список языков)',
	'syntaxhighlight-err-language' => 'Указан неподдерживаемый язык.',
	'geshi.css'                    => '/* CSS-код, размещённый здесь, будет применён для подсветки синтаксиса GeSHI */',
);

/** Yakut (Саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'syntaxhighlight-desc'         => '[http://qbnz.com/highlighter/ GeSHi Highlighter] көмөтүнэн синтаксис подсветкатын холбуурга <tt><nowiki><source></nowiki></tt> тиэги туһанар кыах биэрэр.',
	'syntaxhighlight-specify'      => 'Омугун тылын маннык ыйыахтааххын:',
	'syntaxhighlight-supported'    => 'Өйөнүллэр тыллара:',
	'syntaxhighlight-err-loading'  => '(тылларын испииһэгэ кыайан көрдөрүллүбэтэ)',
	'syntaxhighlight-err-language' => 'Өйөнүллүбэт тыл эбит.',
	'geshi.css'                    => '/* манна баар CSS-куод GeSHI синтаксииһын сырдатарга туттуллуо */',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'syntaxhighlight-desc'         => 'Poskytuje zvýazňovanie syntaxe <tt><nowiki><source></nowiki></tt> pomocou [http://qbnz.com/highlighter/ zvýrazňovača GeSHi]',
	'syntaxhighlight-specify'      => 'Musíte uviesť jazyk takto:',
	'syntaxhighlight-supported'    => 'Jazyky, pre ktoré je zvýrazňovanie syntaxe podporované:',
	'syntaxhighlight-err-loading'  => '(chyba pri načítaní zoznamu podporovaných jazykov)',
	'syntaxhighlight-err-language' => 'Neplatný jazyk.',
	'geshi.css'                    => '/* Tu umiestnené CSS sa použije pre zvýrazňovanie syntaxe GeSHi */',
);

/** Serbian Cyrillic ekavian (ћирилица)
 * @author Sasa Stefanovic
 * @author Millosh
 */
$messages['sr-ec'] = array(
	'syntaxhighlight-specify'      => 'Потребно је одредити језик као овај:',
	'syntaxhighlight-supported'    => 'Подржани језици у визуелом означавању синтаксе:',
	'syntaxhighlight-err-loading'  => '(грешка при учитавању подржаних језика)',
	'syntaxhighlight-err-language' => 'Неподобан језик',
	'geshi.css'                    => '/* CSS постављен овде биће примењен на визуелно означавање синтксе GeSHi */',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'syntaxhighlight-specify'      => 'Ju wonskede Sproake mout as foulget definierd wäide:',
	'syntaxhighlight-supported'    => 'Unnerstöände Sproaken foar ju Syntax-Betoonenge:',
	'syntaxhighlight-err-loading'  => '(Failer bie dät Leeden fon ju Sproakenlieste)',
	'syntaxhighlight-err-language' => 'Uungultige Sproake.',
	'geshi.css'                    => '/* CSS in disse MediaWiki-Systemättergjucht wäd ap ju GeSHi-Syntaxbetoonenge anwoand */',
);

/** Sundanese (Basa Sunda)
 * @author Kandar
 */
$messages['su'] = array(
	'syntaxhighlight-desc'         => 'Nyadiakeun sorotan rumpaka <tt><nowiki><source></nowiki></tt> migunakeun [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Anjeun kudu milih basa kawas kieu:',
	'syntaxhighlight-supported'    => 'Basa nu dirojong ku sorotan rumpaka:',
	'syntaxhighlight-err-loading'  => '(éror ngamuat daptar basa nu dirojong)',
	'syntaxhighlight-err-language' => 'Basana teu sah.',
	'geshi.css'                    => '/* CSS nu diperenahkeun di dieu bakal dilarapkeun ka sorotan rumpaka GeSHi */',
);

/** Swedish (Svenska)
 * @author Lejonel
 */
$messages['sv'] = array(
	'syntaxhighlight-desc'         => 'Ger syntaxmarkering med [http://qbnz.com/highlighter/ GeSHi Highlighter] inuti <tt><nowiki><source></nowiki></tt>-taggar',
	'syntaxhighlight-specify'      => 'Du måste ange vilket språk som används, så här:',
	'syntaxhighlight-supported'    => 'Det finns stöd för följande språk:',
	'syntaxhighlight-err-loading'  => '(fel vid laddning av listan över stödda språk)',
	'syntaxhighlight-err-language' => 'Ogiltigt språk.',
	'geshi.css'                    => '/* CSS som skrivs här används för syntax highlighting med GeSHI */',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'syntaxhighlight-specify'      => 'భాషని ఈ విధంగా ఇవ్వాలి:',
	'syntaxhighlight-err-loading'  => '(తోడ్పాటున్న భాషల జాబితా లోడింగులో పొరపాటు జరిగింది)',
	'syntaxhighlight-err-language' => 'తప్పుడు భాష.',
);

/** Tajik (Cyrillic) (Тоҷикӣ/tojikī (Cyrillic))
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'syntaxhighlight-desc'         => 'Имкони дастуроти рангин карданро <tt><nowiki><source></nowiki></tt> бо истифода аз [http://qbnz.com/highlighter/ GeSHi Highlighter]-ро фароҳам меоварад',
	'syntaxhighlight-specify'      => 'Шумо бояд бо ин шакл забонеро мушаххас кунед:',
	'syntaxhighlight-supported'    => 'Забонҳои пуштибонишуда барои рангин кардани дастуроти наҳвӣ:',
	'syntaxhighlight-err-loading'  => '(хато дар богузории забонҳои пуштибонишуда)',
	'syntaxhighlight-err-language' => 'Забони ғайри миҷоз.',
	'geshi.css'                    => '/* CSS инҷо гузошташуда ба дастуроти рангинкунии GeSHi ба кор бурда мешавад */',
);

/** Turkish (Türkçe)
 * @author Erkan Yilmaz
 */
$messages['tr'] = array(
	'syntaxhighlight-err-language' => 'Geçersiz dil.',
);

/** Ukrainian (Українська)
 * @author Ahonc
 */
$messages['uk'] = array(
	'syntaxhighlight-desc'         => 'Дозволяє використовувати тег <tt><nowiki><source></nowiki></tt> для підсвічування синтаксису за допомогою [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Ви повинні зазначити мову наступним чином:',
	'syntaxhighlight-supported'    => 'Підтримувані мови:',
	'syntaxhighlight-err-loading'  => '(неможливо завантажити список мов)',
	'syntaxhighlight-err-language' => 'Зазначена непідтримувана мова.',
	'geshi.css'                    => '/* CSS-код, розміщений тут, буде застосований для підсвічування синтаксису GeSHI */',
);

/** Vèneto (Vèneto)
 * @author Candalua
 */
$messages['vec'] = array(
	'syntaxhighlight-desc'         => 'Evidensia la sintassi dei linguagi de programazion <tt><nowiki><source></nowiki></tt> tramite [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Te ghè da specificar un linguagio in sta maniera:',
	'syntaxhighlight-supported'    => 'Linguagi de cui se pol evidensiar la sintassi coi colori:',
	'syntaxhighlight-err-loading'  => "(eror nel caricamento de l'elenco dei linguagi suportà)",
	'syntaxhighlight-err-language' => 'Linguagio mìa riconossiùo.',
	'geshi.css'                    => "/* I stili CSS inserìi qua i se àplica a l'evidenziazion de sintassi con GeSHi */",
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'syntaxhighlight-desc'         => 'Tô màu cú pháp trong thẻ <tt><nowiki><source></nowiki></tt> dùng [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify'      => 'Bạn cần phải định rõ một ngôn ngữ như vầy:',
	'syntaxhighlight-supported'    => 'Các ngôn ngữ được tô màu cú pháp:',
	'syntaxhighlight-err-loading'  => '(gặp lỗi khi nạp danh sách các ngôn ngữ được hỗ trợ)',
	'syntaxhighlight-err-language' => 'Ngôn ngữ không hợp lệ.',
	'geshi.css'                    => '/* Bộ tô màu cú pháp GeSHi sẽ áp dụng mã CSS ở đây */',
);

/** Volapük (Volapük)
 * @author Smeira
 * @author Malafaya
 */
$messages['vo'] = array(
	'syntaxhighlight-specify'      => 'Nedol välön püki ön mod soik:',
	'syntaxhighlight-supported'    => 'Püks lonöföl pro süntag pekölöl:',
	'syntaxhighlight-err-loading'  => '(pöl pö lodam lised pükas lonöföl)',
	'syntaxhighlight-err-language' => 'Pük no dabinöl.',
);

/** Yue (粵語)
 * @author Shinjiman
 */
$messages['yue'] = array(
	'syntaxhighlight-desc'         => '用[http://qbnz.com/highlighter/ GeSHi Highlighter]以<tt><nowiki><source></nowiki></tt>提供醒目提示',
	'syntaxhighlight-specify'      => '你需要指定一種語言，好似咁:',
	'syntaxhighlight-supported'    => '語法醒目標示所支援嘅語言:',
	'syntaxhighlight-err-loading'  => '(支援語言清單載入錯誤)',
	'syntaxhighlight-err-language' => '無效嘅語言。',
	'geshi.css'                    => '/* 放響呢度嘅CSS會以GeSHi語法醒目提示方式顯示 */',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Shinjiman
 */
$messages['zh-hans'] = array(
	'syntaxhighlight-desc'         => '使用[http://qbnz.com/highlighter/ GeSHi Highlighter]以<tt><nowiki><source></nowiki></tt>提供高亮',
	'syntaxhighlight-specify'      => '您需要指定一种语言，像这样:',
	'syntaxhighlight-supported'    => '语法高亮所支持的语言:',
	'syntaxhighlight-err-loading'  => '(支持语言列表载入错误)',
	'syntaxhighlight-err-language' => '无效的语言。',
	'geshi.css'                    => '/* 放在这里的CSS会以GeSHi语法高亮方式显示 */',
);

/** Traditional Chinese (‪中文(繁體)‬)
 * @author Shinjiman
 */
$messages['zh-hant'] = array(
	'syntaxhighlight-desc'         => '使用[http://qbnz.com/highlighter/ GeSHi Highlighter]以<tt><nowiki><source></nowiki></tt>提供醒目提示',
	'syntaxhighlight-specify'      => '您需要指定一種語言，像這樣:',
	'syntaxhighlight-supported'    => '語法醒目標示所支援的語言:',
	'syntaxhighlight-err-loading'  => '(支援語言清單載入錯誤)',
	'syntaxhighlight-err-language' => '無效的語言。',
	'geshi.css'                    => '/* 放在這裏的CSS會以GeSHi語法醒目提示方式顯示 */',
);

