<?php
/**
 * Internationalisation file for extension MultiUpload.
 *
 * @addtogroup Extensions
*/

$messages = array();

$messages['en'] = array(
	'multipleupload'                   => "Upload files",
	'multipleupload-desc'              => 'Allows users to [[Special:MultipleUpload|upload several files at once]]',
	'multipleupload-ignoreallwarnings' => "Ignore '''all warnings''' and save the files anyway.",
	'multipleupload-saveallfiles'      => "Save all files",
	'multipleupload-addresswarnings'   => "Please address any warnings before reuploading files.",
	'multipleupload-page'              => "{{ns:project}}:File deletion policy",
	'multipleupload-text'              => "Upload multiple files here.

Choose 'Browse' and select each file you wish to upload. You can upload from 1 to $1 files at a time.

You can enter an optional '''Destination filename''' and provide a '''Summary''' describing your file.

Inappropriate files will be deleted immediately, see the [[{{MediaWiki:Multipleupload-page}}|file deletion policy]].",
	'multiupload-fileuploaded'         => "File uploaded.",
	'multiupload-toolbox'              => "Upload multiple files",
);

/** Arabic (العربية)
 * @author Meno25
 * @author SPQRobin
 */
$messages['ar'] = array(
	'multipleupload'                   => 'رفع الملفات',
	'multipleupload-desc'              => 'يسمح للمستخدمين [[Special:MultipleUpload|برفع عدة ملفات في وقت واحد]]',
	'multipleupload-ignoreallwarnings' => "تجاهل '''كل التحذيرات''' واحفظ الملفات على أية حال.",
	'multipleupload-saveallfiles'      => 'حفظ كل الملفات',
	'multipleupload-addresswarnings'   => 'من فضلك صحح أية تحذيرات قبل إعادة رفع الملفات.',
	'multipleupload-page'              => '{{ns:project}}:سياسة حذف الصور',
	'multipleupload-text'              => "ارفع ملفات متعددة هنا.

اختر 'Browse' واختر كل ملف تود رفعه. يمكنك رفع من 1 إلى $1 ملف في المرة.

يمكنك إدخال '''اسم ملف الوجهة''' اختياريا وتوفير '''ملخص''' يصف صورتك.

الصور غير الملائمة سيتم حذفها فورا، انظر [[{{MediaWiki:Multipleupload-page}}|سياسة حذف الصور]].",
	'multiupload-fileuploaded'         => 'تم رفع الملف.',
	'multiupload-toolbox'              => 'رفع ملفات متعددة',
);

$messages['bg'] = array(
	'multipleupload'    => 'Качване на файлове',
	'multipleupload-ignoreallwarnings' => 'Пренебрегване на \'\'\'всички предупреждения\'\'\' и съхраняване на файловете въпреки тях.',
	'multipleupload-saveallfiles' => 'Запазване на всички файлове',
	'multipleupload-page' => '{{ns:project}}:Политика за изтриване на файлове',
);

/** German (Deutsch)
 * @author Raimond Spekking
 */
$messages['de'] = array(
	'multipleupload'                   => 'Dateien hochladen',
	'multipleupload-desc'              => 'Erlaubt das [[Special:MultipleUpload|Hochladen mehrerer Dateien]] in einer Aktion',
	'multipleupload-ignoreallwarnings' => "Ignoriere '''alle Warnungen''' und speichere die Dateien.",
	'multipleupload-saveallfiles'      => "Alle Dateien speichern",
	'multipleupload-addresswarnings'   => "Bitte jede Warnung anzeigen vor dem erneuten Hochladen von Dateien.",
	'multipleupload-page'              => "{{ns:project}}:Löschrichtlinien",
	'multipleupload-text'              => "Gleichzeitiges Hochladen mehrerer Dateien.

Wähle 'Browse' und wähle jede Datei aus, die du hochladen möchtest. Du kannst gleichzeitig zwischen 1 und $1 Dateien hochladen.

Du kannst wahlweise auch einen '''Ziel-Dateinamen''' vorgeben und eine '''Beschreibung''' für deine Dateien.

Ungeeignete Dateien werden sofort gelöscht, siehe die [[{{MediaWiki:Multipleupload-page}}|Löschrichtlinien]].",
	'multiupload-fileuploaded'         => 'Datei hochgeladen.',
	'multiupload-toolbox'              => 'Hochladen mehrerer Dateien',
);

/** Greek (Ελληνικά)
 * @author Consta
 */
$messages['el'] = array(
	'multipleupload'              => 'Επιφόρτιση αρχείων',
	'multipleupload-saveallfiles' => 'Αποθηκεύστε όλα τα αρχεία',
);

/** French (Français)
 * @author Grondin
 * @author Dereckson
 * @author Urhixidur
 */
$messages['fr'] = array(
	'multipleupload'                   => 'Importer (téléverser) des fichiers',
	'multipleupload-desc'              => 'Permet aux utilisateurs d’importer (téléverser), [[Special:MultipleUpload|en une seule fois, plusieurs fichiers]]',
	'multipleupload-ignoreallwarnings' => "Ignorer '''tous les avertissements''' et sauvegarder les fichiers malgré tout.",
	'multipleupload-saveallfiles'      => 'Sauvegarder tous les fichiers',
	'multipleupload-addresswarnings'   => 'Vérifiez les avertissements affichés avant d’importer (téléverser) à nouveau les fichiers.',
	'multipleupload-page'              => '{{ns:project}}:Règles de suppression de fichiers',
	'multipleupload-text'              => "Importez (Téléversez) plusieurs fichiers ici.

Choisissez « Rechercher » et sélectionnez chaque fichier que vous voulez importer. Vous pouvez importer de 1 à $1 fichiers à la fois.

Vous pouvez optionnellement spécifier la '''destination du fichier''' et remplir le '''Sommaire''' pour décrire votre image.

Les images non pertinentes pourront être supprimées immédiatement. Voyez la page des [[{{MediaWiki:Multipleupload-page}}|Règles de suppression d’images]].",
	'multiupload-fileuploaded'         => 'Fichier importé (téléversé).',
	'multiupload-toolbox'              => 'Importer (Téléverser) plusieurs fichiers',
);

/** Galician (Galego)
 * @author Xosé
 * @author Alma
 */
$messages['gl'] = array(
	'multipleupload'                   => 'Enviar ficheiros',
	'multipleupload-ignoreallwarnings' => "Ignorar '''todas as advertencias''' e gardar os ficheiros igual.",
	'multipleupload-saveallfiles'      => 'Gardar todos os ficheiros',
	'multipleupload-addresswarnings'   => 'Atenda as advertencias antes volver a enviar ficheiros.',
	'multipleupload-text'              => "Envíe varios ficheiros aquí.

Escolla \"Navegar\" (ou \"Browse\") e escolla cada un dos ficheiros que queira enviar. Pode enviar entre 1 e \$1 ficheiros de cada vez.

Pode introducir un '''Nome de ficheiro de destino''' opcional e fornecer un '''Resumo''' que describa o seu ficheiro.

Os ficheiros inapropiados eliminaranse inmediatamente: vexa a [[{{MediaWiki:Multipleupload-page}}|política de eliminación de ficheiros]].",
	'multiupload-fileuploaded'         => 'Arquivo cargado.',
	'multiupload-toolbox'              => 'Cargar múltiples arquivos',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'multipleupload'                   => 'Dataje nahrać',
	'multipleupload-desc'              => 'Dowola wužiwarjam [[Special:MultipleUpload|wjacore dataje na jedne dobo nahrać]]',
	'multipleupload-ignoreallwarnings' => "'''Wšě warnowanja''' ignorować a dataje składować.",
	'multipleupload-saveallfiles'      => 'Wšě dataje składować',
	'multipleupload-addresswarnings'   => 'Prošu wobkedźbuj warnowanja, prjedy hač dataje znowa nahraješ.',
	'multipleupload-page'              => '{{ns:project}}:Prawidła za wušmórnjenje wobrazow',
	'multipleupload-text'              => "Nahraj wjacore dataje jowle.

Wuzwolij 'Přepytać' a wubjer kóždu dataju, kotruž chceš nahrać. Móžeš 1 hač $1 {{PLURAL:$1|dataju|dataji|dataje|datajow}} naraz nahrać.

Móžeš opcionalne '''mjeno za cilowu dataju''' zapodać a '''Zjeće''' podać, kotrež twoje foto wopisuje.

Njepřihódne wobrazy budu so hnydom wušmórować, hlej [[{{MediaWiki:Multipleupload-page}}|prawidła za wušmórnjenje wobrazow]].",
	'multiupload-fileuploaded'         => 'Dataja nahrata.',
	'multiupload-toolbox'              => 'Wjacore dataje nahrać',
);

/** Hungarian (Magyar)
 * @author Bdanee
 */
$messages['hu'] = array(
	'multipleupload'                   => 'Fájlok feltöltése',
	'multipleupload-ignoreallwarnings' => "Az '''összes figyelmeztetés''' mellőzése és a fájlok elmentése.",
	'multipleupload-saveallfiles'      => 'Összes fájl mentése',
	'multipleupload-page'              => '{{ns:project}}:Fájltörlési irányelvek',
	'multiupload-fileuploaded'         => 'Fájl feltöltve.',
	'multiupload-toolbox'              => 'Több fájl feltöltése',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'multipleupload'           => 'Fichieren eroplueden',
	'multiupload-fileuploaded' => 'Fichier eropgelueden',
);

/** Dutch (Nederlands)
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'multipleupload'                   => 'Bestanden uploaden',
	'multipleupload-desc'              => 'Laat gebruikers toe om meerdere bestanden [[Special:MultipleUpload|in één keer te uploaden]]',
	'multipleupload-ignoreallwarnings' => "'''Alle waarschuwingen''' negeren en de bestanden sowieso uploaden.",
	'multipleupload-saveallfiles'      => 'Alle bestanden opslaan',
	'multipleupload-addresswarnings'   => 'Los alstublieft de waarschuwingen op voordat u het opnieuw probeert.',
	'multipleupload-page'              => '{{ns:project}}:Verwijderingsbeleid van bestanden',
	'multipleupload-text'              => "Hier kunt u verschillende bestanden uploaden.

Kies 'Doorzoeken' en selecteer elk bestand dat u wil uploaden. U kan van 1 tot $1 bestanden tegelijk uploaden.

U kunt een optionele '''Bestemming bestandsnaam'''  opgeven en een '''Samenvatting''' die uw bestand beschrijft opgeven.

Onrelevante afbeeldingen zullen onmiddelijk verwijderd worden, zie het [[{{MediaWiki:Multipleupload-page}}|verwijderingsbeleid van bestanden]].",
	'multiupload-fileuploaded'         => 'Bestand toegevoegd.',
	'multiupload-toolbox'              => 'Meerdere bestanden uploaden',
);

/** Norwegian (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 */
$messages['no'] = array(
	'multipleupload'                   => 'Last opp filer',
	'multipleupload-desc'              => 'Lar brukere [[Special:MultipleUpload|laste opp flere filer på én gang]]',
	'multipleupload-ignoreallwarnings' => "Ignorer '''alle advarsler''' og lagre filene likevel.",
	'multipleupload-saveallfiles'      => 'Lagre alle filer',
	'multipleupload-addresswarnings'   => 'Vennligst addresser alle advarsler før du laster opp filene igjen.',
	'multipleupload-page'              => '{{ns:project}}:Retningslinjer for filsletting',
	'multipleupload-text'              => "Last opp flere filer her.

Velg «Naviger» og velg de filene du ønsker å laste opp. Du kan laste opp mellom 1 og $1 filer på én gang.

Du kan skrive inn et valgfritt '''målnavn''' og oppgi et '''sammendrag''' for å beskrive filen.

Upassende filer vil bli slettet umiddelbart, se [[{{MediaWiki:Multipleupload-page}}|retningslinjene for filsletting]].",
	'multiupload-fileuploaded'         => 'Fil lastet opp.',
	'multiupload-toolbox'              => 'Last opp flere filer',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'multipleupload'                   => 'Telecargar de fichièrs',
	'multipleupload-ignoreallwarnings' => "Ignorar '''totes los avertiments''' e salvagardar los fichièrs en question.",
	'multipleupload-saveallfiles'      => 'Salvagardar totes los fichièrs',
	'multipleupload-addresswarnings'   => 'Verificatz los avertiments afichats abans de telecargar los fichièrs tornamai.',
	'multipleupload-page'              => '{{ns:project}}:Règlas per la supression de fichièr',
	'multipleupload-text'              => "Telecargar mantun fichièr aicí.

Causissetz « Recercar » e seleccionatz cada fichièr que volètz telecargar. Ne podètz telecargar actualament de 1 fins a $1. 

Podètz inscriure la '''destinacion del fichièr''' e emplenar lo '''Somari''' per descriure vòstre imatge.

Los imatges pas pertinents poiràn èsser escafadas immediatament. Vejatz la pagina [[{{MediaWiki:Multipleupload-page}}|image deletion policy]].",
	'multiupload-fileuploaded'         => 'Fichièr telecargat',
	'multiupload-toolbox'              => 'Telecargar mantun fichièr',
);

$messages['pl'] = array(
	'multipleupload' => "Prześlij pliki",
	'multipleupload-ignoreallwarnings' => "Ignoruj <b>wszystkie ostrzeżenia</b> i zapisz pliki.",
	'multipleupload-saveallfiles' => "Zapisz wszystkie pliki",
	'multipleupload-addresswarnings' => "Rozwiąż wszystkie problemy, zanim prześlesz pliki.",
	'multipleupload-text' => "Prześlij wszystkie wymienione pliki. <br/><br/>
			Kliknij 'Przeglądaj...' i wybierz plik, który chcesz wysłac. Możesz wysłać od 1 do $1
			plików za jednym razem. <br/><br/>
			Możesz wprowadzić opcjonalne <b>$2</b> i <b>$3</b> opisujące wysyłany plik. <br/><br/>
			<br/>
			Nieprawidłowe pliki będą natychmiast kasowane, zobacz [[Projekt:Zasady kasowania plików|Zasady kasowania plików]].<br/><br/>
				",
);

/** Portuguese (Português)
 * @author Malafaya
 */
$messages['pt'] = array(
	'multipleupload'                   => 'Carregar ficheiros',
	'multipleupload-ignoreallwarnings' => "Ignorar '''todos os avisos''' e, mesmo assim, gravar os ficheiros.",
	'multipleupload-saveallfiles'      => 'Gravar todos os ficheiros',
	'multipleupload-page'              => '{{ns:project}}:Política de eliminação de ficheiros',
	'multiupload-fileuploaded'         => 'Ficheiro carregado.',
	'multiupload-toolbox'              => 'Carregar múltiplos ficheiros',
);

/** Russian (Русский)
 * @author .:Ajvol:.
 */
$messages['ru'] = array(
	'multipleupload'                   => 'Загрузка файлов',
	'multipleupload-ignoreallwarnings' => "Игнорировать '''все предупреждения''' и сохранять файлы в любом случае.",
	'multipleupload-saveallfiles'      => 'Сохранить все файлы',
	'multipleupload-addresswarnings'   => 'Пожалуйста, рассмотрите все предупреждения перед повторной загрузкой файлов.',
	'multipleupload-page'              => '{{ns:project}}:Правила удаления файлов',
	'multipleupload-text'              => 'С помощью этой страницы можно загрузить сразу несколько файлов.

Нажмите «Обзор» и выберите файл, который вы хотите загрузить. Вы можете загрузить от 1 до $1 файлов за один раз.

Вы можете заполнить необязательные поля «Целевое имя файла», указать «Краткие описания» для ваших файлов.

Неподходящие файлы будут удалены немедленно, см. [[{{MediaWiki:Multipleupload-page}}|правила удаления файлов]].',
	'multiupload-fileuploaded'         => 'Файл загружен.',
	'multiupload-toolbox'              => 'Загрузка нескольких файлов',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'multipleupload'                   => 'Nahrať súbory',
	'multipleupload-desc'              => 'Umožňuje používateľom [[Special:MultipleUpload|nahrať viacero súborov naraz]]',
	'multipleupload-ignoreallwarnings' => "Ignorovať '''všetky upozornenia''' a napriek nim súbor uložiť.",
	'multipleupload-saveallfiles'      => 'Uložiť všetky súbory',
	'multipleupload-addresswarnings'   => 'Prosím, predtým než znovu nahráte súbory, napravte všetky upozornenia.',
	'multipleupload-page'              => '{{ns:project}}:Pravidlá mazania súborov',
	'multipleupload-text'              => "Tu môžete nahrať viacero súborov.

Tlačidlom „Prehliadať“ vyberte každý súbor, ktorý chcete nahrať. Môžete nahrať od 1 do $1 súborov naraz.

Môžete zadať voliteľný '''Cieľový názov súboru''' a poskytnúť '''Zhrnutie''' popisujúce váš súbor.

Nevhodné súbory budú okamžite zmazané, pozri [[{{MediaWiki:Multipleupload-page}}|pravidlá mazania súborov]].",
	'multiupload-fileuploaded'         => 'Súbor nahraný.',
	'multiupload-toolbox'              => 'Nahrať viacero súborov',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'multipleupload'                   => 'Doatäie hoochleede',
	'multipleupload-ignoreallwarnings' => "Ignorier '''aal Woarschauengen''' un spiekerje do Doatäie",
	'multipleupload-saveallfiles'      => 'Aal Doatäie spiekerje',
	'multipleupload-addresswarnings'   => 'Älke Woarschauenge anwiese foar dät fonnäien Hoochleeden fon Doatäie.',
	'multipleupload-page'              => '{{ns:project}}:Läskgjuchtlienjen',
	'multipleupload-text'              => "Tou glieke Tied Hoochleeden fon moorere Doatäie.

Wääl 'Browse' un wääl älke Doatäi uut, ju du hoochleede moatest. Du koast tou glieke Tied twiske 1 un $1 Doatäie hoochleede.

Du koast woalwiese uk n '''Siel-Doatäinoome''' foarreeke un ne '''Beschrieuwenge''' foar dien Doatäie.

Uunoainde Doatäie wäide fluks läsked, sjuch do [[{{MediaWiki:Multipleupload-page}}|Läskgjuchtlienjen]].",
	'multiupload-fileuploaded'         => 'Doatäi hoochleeden.',
	'multiupload-toolbox'              => 'Hoochleeden fon moorere Doatäie',
);

/** Swedish (Svenska)
 * @author M.M.S.
 */
$messages['sv'] = array(
	'multipleupload'              => 'Ladda upp filer',
	'multipleupload-saveallfiles' => 'Spara alla filer',
	'multipleupload-page'         => '{{ns:project}}:Filborttagnings policy',
	'multiupload-fileuploaded'    => 'Fil uppladdad.',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'multipleupload'              => 'ఫైళ్ళను ఎగుమతించు',
	'multipleupload-saveallfiles' => 'అన్ని ఫైళ్ళనూ భద్రపరచు',
	'multipleupload-page'         => '{{ns:project}}:ఫైలు తొలగింపు విధానం',
	'multiupload-fileuploaded'    => 'ఫైలు ఎగుమతయ్యింది.',
);

/** Thai (ไทย)
 * @author Passawuth
 */
$messages['th'] = array(
	'multipleupload'                   => 'อัปโหลดไฟล์',
	'multipleupload-ignoreallwarnings' => "ไม่สนใจ '''คำเตือน''' และบันทึกไฟล์",
	'multipleupload-saveallfiles'      => 'บันทึกไฟล์ทั้งหมด',
	'multiupload-fileuploaded'         => 'ไฟล์ถูกอัปโหลดเรียบร้อยแล้ว',
);

