<?php
   /**
   * Gets included in download_jacket.phtml if linux OS is detected.
   */
   ?>

<div class="download_instructions_container">
  <div class="header">Linux Installation Instructions</div>
  <div class="links">
    <a href="#section_2">Installation</a> | <a href="#section_3">Activation</a> | <a href="#section_4">Additional Help</a>
  </div>

  <div class="section">
    <div class="header">Download and Run the Installer</div>

    <table>
      <tr>
        <td>Click 'Save' when prompted by your browser.  The instructions on
        this page will assume you have placed the downloaded .run file
        in <code>/usr/local</code>.<br><br></td>
      </tr>
      <tr>
        <td>Open a terminal and type <code>cd /usr/local</code>.<br><br></td>
      </tr>
      <tr>
        <td>Type <code>./Jacket-linux-X.X-date.run</code> or <code>sudo
        ./Jacket-linux-X.X-date.run</code> if you wish to install Jacket in a
        location that requires root permission. Replace X with the date
        appended to the end of your download file.</td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_2">
    <div class="header">Installation</div>

    <table>
      <tr>
        <td class="info">
          The installer will now verify and unpack Jacket.<br><br>  When
          prompted to accept the license agreement <a href="/eula"
          target="_blank">Click Here</a> to view and read the EULA.<br><br>
          Once done, type <code>yes</code> to continue with the installation.
        </td>
        <td class="code_container">
          Verifying archive integrity... All good.<br>
          Uncompressing AccelerEyes Jacket.....<br>
          <br>
          Do you accept the license (see http://www.accelereyes.com/eula)?
          (yes/no/abort): <strong>yes</strong><br> Thank you for accepting the
          license. The installation process will now proceed.<br>
        </td>
      </tr>
      <tr><td colspan="2"><br></td></tr>
      <tr>
        <td colspan="2"><br></td>
      </tr>
      <tr>
        <td class="info">
          Next you will be prompted for the installation path for Jacket.
          Assuming you started the installer in <code>/usr/local</code> simply
          press enter here to accept the default.
        </td>
        <td class="code_container">
          Enter install path :  <code>/jacket</code> will be appended (default /usr/local/jacket):
        </td>
      </tr>
      <tr>
        <td colspan="2"><br></td>
      </tr>
      <tr>
        <td class="info">
          Choose the MATLAB version installed on your system. Type "older" if you are using
          MATLAB R2007B (or "newer" if you are using R2008A or newer) and press enter.
        </td>
        <td class="code_container">
          Which version of MATLAB are you using?<br>
          Type "older" if you are using R2007B or older.<br> 
          Type "newer" if you are using R2008A or newer.<br> 
        </td>
      </tr>
      <tr><td colspan="2"><br></td></tr>
      <tr>
        <td class="info">
          Now Jacket will finish installing and the final output will match
          what is displayed on the right.  Be sure to follow any path-related
          instructions displayed here.<br>
        </td>
        <td class="code_container">
          Making final adjustments ....<br>
          <br>
          * To finish installing Jacket, please make sure your MATLAB PATH includes /usr/local/jacket/engine<br>
          <br>
         * Please read the release notes on the website: http://wiki.accelereyes.com/wiki/index.php/Release_Notes<br>
          <br>
          * To uninstall Jacket, delete /usr/local/jacket<br>
          <br>
          * Installation Complete<br>
        </td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_3">
    <div class="header">Activation</div>

    <table>
      <tr>
        <td>Please visit the <a href="/support/documentation"
        target="_blank">Documentation Section</a> of our website for help with
        activating your Jacket license in Linux.</td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_4">
    <div class="header">Additional Help</div>

    <table>
      <tr>
        <td>
          For instructions on installing Jacket for OSX please refer to
          the <a href="http://wiki.accelereyes.com/wiki/index.php/Jacket_Installation"
          target="_blank">Documentation Section</a> of our website. For
          additional assistance join the <a href="/forums"
          target="_blank">Jacket Forums</a> discussion or
          contact <a href="mailto:support@accelereyes.com">support@accelereyes.com</a>.
        </td>
      </tr>
    </table>

  </div>
</div>
