<?php
   /**
   * Gets included in download_jacket.phtml if OSX OS is detected.
   */
   ?>

<div class="download_instructions_container">
  <div class="header">OSX Installation Instructions</div>
  <div class="links">
    <a href="#section_1">Installation</a><br>
    <a href="#section_2">Support</a><br>
    <a href="#section_3">ArrayFire Licensing</a>
  </div>
  <div class="section" id="section_1">
    <div class="header">Installation</div>
     
    <table>
     <tr>
     <td>Unpack ArrayFire using unzip<br>
     </td>
     <td class="code_container">
     accelereyes$: unzip ArrayFire-osx-00907d.zip<br>
     Archive:  ArrayFire-osx-00a907d.zip<br>
     inflating: arrayfire/include/arrayfire.h<br>
     inflating: arrayfire/include/arrayfire.f95<br>
     inflating: arrayfire/include/af/constants.h<br>
     inflating: arrayfire/include/af/context.h<br>
     .....<br>
     </td>
     </tr>
     <tr>
     <br>
     ArrayFire examples assume the CUDA Toolkit to be installed at <code>/usr/local/cuda</code>.
     If installed elsewhere, set the CUDA environment variable to the alternate location <code>(CUDA=/opt/software/cuda)</code> or
     modify the default variable setting in <code>/home/accelereyes/arrayfire/examples/common.mk</code>.
     <br><br>   
     </tr>
     <tr>
     <td>ArrayFire includes many examples that demonstrates its features.
     For example, to build <code>examples/template</code>, navigate to the 
     template example directory and enter <code>make clean && make && ./template</code>.
     </td>
     <td class="code_container">
     accelereyes$: cd arrayfire/examples/template<br>
     accelereyes$: pwd<br>
     /home/accelereyes/arrayfire/examples/template<br>
     accelereyes$: make clean && make && ./template<br>
     Tm -f *.o template<br>
     g++  -m64 -Wall -Werror -I../../include -I/usr/local/cuda/include -O2 -DNDEBUG -lafGFX -L../../lib -Olaf  -L/usr/local/cuda/lib -lcuda -lcudart -lpthread -lstdc++ -Wl,-rpath,../../lib,-rpath,/private/tmp/arrayfire/lib,-rpath,/usr/local/cuda/lib  template.cpp   -o template<br>
     ArrayFire v1.0 (build 00a907d) by AccelerEyes (64-bit Mac OSX)<br>
     License Type: Concurrent Network (27000@www.accelereyes.com)<br>
     Addons: none<br>
     CUDA toolkit 4.0<br>
     GPU0 GeForce 320M, 253 MB, Compute 1.2 (single)<br>
     Display Device: GPU0 GeForce 320M<br>
     Memory Usage: 228 MB free (253 MB total)<br>
     </td>
     </tr>
     <tr>
     <td>
     (Recommended) Set the AF_PATH environment variable to where you installed ArrayFire. Also add it to <code>~/.bashrc</code> for future sessions.
     </td>
     <td class="code_container">
     accelereyes $ export AF_PATH=/home/accelereyes/arrayfire<br>
     accelereyes $ echo export AF_PATH=/home/accelereyes/arrayfire >> ~/.bashrc<br>
     accelereyes $ echo $AF_PATH<br>
     /home/accelereyes/arrayfire<br>
     </td>
     </tr>
    </table>
     <br>
     <strong>NOTE: MacOSX needs X11 to be running only for graphical examples.</strong>
  </div>

  <div class="section" id="section_2">
    <div class="header">Support</div>

    <table>
      <tr>
        <td>
          Online documentation for ArrayFire is available at <a href="http://www.accelereyes.com/arrayfire_cuda/"
          target="_blank">ArrayFire CUDA</a> page. 
          For additional assistance join the <a href="http://forums.accelereyes.com/forums/"
          target="_blank">ArrayFire Forums</a> discussion or
          contact <a href="mailto:support@accelereyes.com">support@accelereyes.com</a>.
        </td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_3">
    <div class="header">ArrayFire Licensing</div>
    <table>
      <tr>
       <td>
       By default, ArrayFire authenticates for free using hosted license servers at www.accelereyes.com.<br><br>
       <a href="http://www.accelereyes.com/products/arrayfire_licensing">ArrayFire Pro</a> adds several features not found in the free version,
       including the ability to run offline, <a href="http://www.accelereyes.com/arrayfire_cuda/group__device__mat.htm">run multiple devices in parallel</a>,
       <a href="http://www.accelereyes.com/arrayfire_cuda/group__linalg__mat.htm">double-precision linear algebra</a>,
       <a href="http://www.accelereyes.com/arrayfire_cuda/group__sparse__mat.htm">sparse linear algebra</a>, and more.
       Use the <a href="https://www.accelereyes.com/customer/account/login">Manage Licenses</a> page to start a Pro trial
       or download a purchased license file.<br>
       Save the downloaded license file to <code>$HOME/arrayfire.lic</code> (or <code>$HOME/.arrayfire.lic</code> to make it a hidden file).
       <br><br>
       You can also save the license file to the same directory as your project executable.
       </td>
      </tr>
    </table>
  </div>
  </div>

