<?php
class Accelereyes_LicenseSystem_Model_License extends Mage_Core_Model_Abstract {

	protected $licenseNumber = 110000000;
	protected $userType = 'commercial';
	protected $customerId = 0;
	protected $productSku = 0;
	protected $machineId = NULL;
	protected $purchaseDate = 1;
	protected $maintenanceDate = 1;
	protected $supportDate = 0;
	protected $mgo = 2;
	protected $gfxToolbox = 1;
	protected $machineUpdate = 0;
	protected $plp = NULL;
    protected $paid = false;

	protected function _construct()
  {
    $this->_init('licensesystem/license');
  }

	//Getters and setters.
	public function getLicenseNumber() { return $this->licenseNumber; }
	public function getCustomerId() { return $this->customerId; }
	public function getMachineId() { return $this->machineId; }
	public function getPurchaseDate() { return $this->purchaseDate; }
	public function getMaintenanceDate() { return $this->maintenanceDate; }
	public function getGfxToolbox() { return $this->gfxToolbox; }
	public function getProductSku() { return $this->productSku; }
	public function getSupportDate() { return $this->supportDate; }
	public function getMgo() { return $this->mgo; }
	public function getUserType() { return $this->userType; }
	public function getMachineUpdate() { return $this->machineUpdate; }
	public function getPLP() { return $this->plp; }
    public function getPaid() { return $this->paid; }

	public function setLicenseNumber($val) { $this->licenseNumber = $val; }
	public function setCustomerId($val) { $this->customerId = $val; }
	public function setMachineId($val) { $this->machineId = $val; }
	public function setPurchaseDate($val) { $this->purchaseDate = $val; }
	public function setMaintenanceDate($val) { $this->maintenanceDate = $val; }
	public function setGfxToolbox($val) { $this->gfxToolbox = $val; }
	public function setProductSku($val) { $this->productSku = $val; }
	public function setSupportDate($val) { $this->supportDate = $val; }
	public function setMgo($val) { $this->mgo = $val; }
	public function setUserType($val) { $this->userType = $val; }
	public function setMachineUpdate($val) { $this->machineUpdate = $val; }
	public function setPLP($val) { $this->plp = $val; }
    public function setPaid($val) { $this->paid = $val; }

	public function save() {
		$connection = Mage::getSingleton('core/resource')->getConnection('licensesystem_write');
		$connection->beginTransaction();
		$fields = array();
		//$fields['license_number'] = $this->licenseNumber;
		$fields['customer_id'] = $this->customerId;
		$fields['machine_id'] = $this->machineId;
		$fields['purchase_date'] = $this->purchaseDate;
		$fields['maintenance_date'] = $this->maintenanceDate;
		$fields['gfx_toolbox'] = $this->gfxToolbox;
		$fields['product_sku'] = $this->productSku;
		$fields['mgo'] = $this->mgo;
		$fields['support_date'] = $this->supportDate;
		$fields['user_type'] = $this->userType;
		$fields['machine_update'] = $this->machineUpdate;
		$fields['plp'] = $this->plp;
        $fields['paid'] = $this->paid == true ? 1 : 0;

		try {

			$this->_beforeSave();
			$connection->insert('license_account', $fields);
			$connection->commit();
			$this->_afterSave();
		}
		catch (Exception $e) {
			$connection->rollBack();
			throw $e;
		}
	return $this;
	}

	public function update($updateMachine = false) {
		$connection = Mage::getSingleton('core/resource')->getConnection('licensesystem_write');
		$connection->beginTransaction();

		try {

			$this->_beforeSave();
			if ($updateMachine) { $this->machineUpdate++; }

			$sql = "UPDATE license_account SET customer_id = '$this->customerId',
				machine_id = '$this->machineId', purchase_date = '$this->purchaseDate',
				maintenance_date = '$this->maintenanceDate', gfx_toolbox = '$this->gfxToolbox',
				product_sku = '$this->productSku', support_date = '$this->supportDate',
				user_type = '$this->userType', machine_update = '$this->machineUpdate',
				plp = '$this->plp', paid = '$this->paid'
				WHERE license_number = '$this->licenseNumber';";

			$connection->raw_query($sql);
			$connection->commit();
			$this->_afterSave();
		}
		catch (Exception $e) {
			$connection->rollBack();
			throw $e;
		}
	return $this;
	}

	public function load($id, $field=null) {

		if ($id === null) { return;	}

		if ($field === null) {
			$field = 'customer_id';
		}

		$connection = Mage::getSingleton('core/resource')->getConnection('licensesystem_read');
		$select = $connection->select()->from('license_account')->where($field.'=?', $id);
		$data = $connection->fetchRow($select);
		if (!$data) {
			return $this;
		}

		$this->setLicenseNumber($data['license_number']);
		$this->setPurchaseDate($data['purchase_date']);
		$this->setMaintenanceDate($data['maintenance_date']);
		$this->setGfxToolbox($data['gfx_toolbox']);
		$this->setMachineId($data['machine_id']);
		$this->setCustomerId($data['customer_id']);
		$this->setProductSku($data['product_sku']);
		$this->setMgo($data['mgo']);
		$this->setUserType($data['user_type']);
		$this->setSupportDate($data['support_date']);
		$this->setMachineUpdate($data['machine_update']);
		$this->setPLP($data['plp']);
        $this->setPaid($data['paid']);
		$this->_afterLoad();
		return $this;
	}

	public function loadAll($id=null, $field=null) {

		$connection = Mage::getSingleton('core/resource')->getConnection('licensesystem_read');

		if ($id === null) {

			$select = $connection->select()->from('license_account');

		}

		else {
			if ($field === null) {
				$field = 'customer_id';
			}

			$select = $connection->select()->from('license_account')->where($field.'=?', $id);
			//$select .= " ORDER BY 'license_number'";
		}

		$data = $connection->query($select);

		if (!$data) {
			return $this;
		}

		$retArr = array();
		while ($row = $data->fetch() ) {
			$retArr[]=$row;
		}

		return $retArr;
	}

    public function generateLicenseCode()
    {

        $len = 8;
        $base='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz123456789';
        $max=strlen($base)-1;
        $licenseCode='';
        mt_srand((double)microtime()*1000000);
        while (strlen($licenseCode)<$len+1)
            $licenseCode.=$base{mt_rand(0, $max)};

        return $licenseCode;

    }

}
