<?php

class Accelereyes_VersionLibjacket_Block_Admin_New_Form extends Mage_Adminhtml_Block_Widget_Form
{

    protected function _prepareForm()
    {

        $form = new Varien_Data_Form();

        $fieldset = $form->addFieldset('new_version', array('legend' => Mage::helper('versionlibjacket')->__('New Version')));

        $fieldset->addField('version_number', 'text', array(
            'name'      => 'version_number',
            'title'     => Mage::helper('versionlibjacket')->__('Version Number'),
            'label'     => Mage::helper('versionlibjacket')->__('Version Number'),
            'maxlength' => '10',
            'required'  => true,
        ));

        $fieldset->addField('date', 'date', array(
            'name'      => 'date',
            'title'     => Mage::helper('versionlibjacket')->__('Date'),
            'label'     => Mage::helper('versionlibjacket')->__('Date'),
            'align'     => 'right',
            'image'     => Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN) . '/adminhtml/default/default/images/grid-cal.gif',
            'format'    => Mage::app()->getLocale()->getDateFormat(Mage_Core_Model_Locale::FORMAT_TYPE_MEDIUM),
            'required'  => true,
        ));

        $fieldset->addField('Windows Build', 'text', array(
            'name'      => 'windows_build',
            'title'     => Mage::helper('versionlibjacket')->__('Windows Build'),
            'label'     => Mage::helper('versionlibjacket')->__('Windows Build'),
            'maxlength' => '10',
            'required'  => false,
        ));

        $fieldset->addField('Linux Build', 'text', array(
            'name'      => 'linux_build',
            'title'     => Mage::helper('versionlibjacket')->__('Linux Build'),
            'label'     => Mage::helper('versionlibjacket')->__('Linux Build'),
            'maxlength' => '10',
            'required'  => false,
        ));

        $fieldset->addField('OS X Build', 'text', array(
            'name'      => 'osx_build',
            'title'     => Mage::helper('versionlibjacket')->__('OS X Build'),
            'label'     => Mage::helper('versionlibjacket')->__('OS X Build'),
            'maxlength' => '10',
            'required'  => false,
        ));

        $form->setMethod('post');
        $form->setUseContainer(true);
        $form->setId('edit_form');
        $form->setAction($this->getUrl('*/*/post'));

        $this->setForm($form);

    }

}
