<?php

class Accelereyes_Version_Block_Admin_Main_Grid extends Mage_Adminhtml_Block_Widget_Grid
{

    public function __construct()
    {

        parent::__construct();
        $this->setId('versionGrid');
        $this->_controller = 'version';

    }

    protected function _prepareCollection()
    {

        $model = Mage::getModel('version/version');
        $collection = $model->getCollection();
        $this->setCollection($collection);

        return parent::_prepareCollection();

    }

    protected function _prepareColumns()
    {

        $this->addColumn('version_number', array(
            'header'        => Mage::helper('version')->__('Version Number'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'version_number',
            'index'         => 'version_number',
        ));

        $this->addColumn('date', array(
            'header'        => Mage::helper('version')->__('Date'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'date',
            'index'         => 'date',
        ));

        $this->addColumn('mst_pin', array(
            'header'        => Mage::helper('version')->__('Master Pin'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'mst_pin',
            'index'         => 'mst_pin',
        ));

        $this->addColumn('action',
            array(
                'header'    => Mage::helper('version')->__('Action'),
                'width'     => '25px',
                'type'      => 'action',
                'getter'    => 'getVersionId',
                'actions'   => array(
                    array(
                        'caption'   => Mage::helper('version')->__('Edit'),
                        'url'       => array(
                            'base'  => '*/*/edit'
                        ),
                        'field'     => 'id'
                    ),
                    array(
                        'caption'   => Mage::helper('version')->__('Delete'),
                        'url'       => array(
                            'base'  => '*/*/delete'
                        ),
                        'field'     => 'id'
                    )
                ),
                'filter'    => false,
                'sortable'  => false
            )
        );

        return parent::_prepareColumns();

    }

    public function getRowUrl($row)
    {

        return $this->getUrl('*/*/edit', array('id' => $row->getVersionId()));

    }

}
