<?php

class Accelereyes_Salesrep_Block_Admin_Edit_Form extends Mage_Adminhtml_Block_Widget_Form
{

    protected function _prepareForm()
    {

        $form = new Varien_Data_Form(array(
            'id'        => 'edit_form',
            'action'    => $this->getUrl('*/*/save', array('id' =>
                                                     $this->getRequest()->getParam('id'))),
            'method'    => 'post'
        ));

        $fieldset = $form->addFieldset('edit_salesrep', array('legend' =>
                                                        Mage::helper('salesrep')->__('Sales Rep Details')));

        $fieldset->addField('name', 'text', array(
            'name'      => 'name',
            'title'     => Mage::helper('salesrep')->__('Name'),
            'label'     => Mage::helper('salesrep')->__('Name'),
            'maxlength' => '50',
            'required'  => true,
        ));

        $fieldset->addField('company', 'select', array(
            'name'      => 'company',
            'title'     => Mage::helper('salesrep')->__('Company'),
            'label'     => Mage::helper('salesrep')->__('Company'),
            'options'   => $this->_getCompaniesArray(),
            'required'  => true,
        ));

        $fieldset->addField('address', 'text', array(
            'name'      => 'address',
            'title'     => Mage::helper('salesrep')->__('Address'),
            'label'     => Mage::helper('salesrep')->__('Address'),
            'maxlength' => '50',
            'required'  => true,
        ));

        $fieldset->addField('phone', 'text', array(
            'name'      => 'phone',
            'title'     => Mage::helper('salesrep')->__('Phone'),
            'label'     => Mage::helper('salesrep')->__('Phone'),
            'maxlength' => '50',
            'required'  => true,
        ));

        $fieldset->addField('customer_id', 'text', array(
            'name'      => 'customer_id',
            'title'     => Mage::helper('salesrep')->__('Customer ID'),
            'label'     => Mage::helper('salesrep')->__('Customer ID'),
            'maxlength' => '50',
            'required'  => false,
        ));

        $form->setUseContainer(true);
        $form->setValues(Mage::registry('frozen_salesrep')->getData());
        $this->setForm($form);
        return parent::_prepareForm();

    }

    protected function _getCompaniesArray()
    {

        $companies = Mage::getModel('reseller/reseller')->getCollection();
        $result = array();
        foreach ($companies as $id => $company) {
            $result[$company->getCompany()] = $company->getCompany();
        }
        return $result;

    }

}
