<?php

class Accelereyes_ResellerOrder_AdminController extends Mage_Adminhtml_Controller_Action
{

  public function indexAction()
  {

    $this->loadLayout()
      ->_addContent($this->getLayout()->createBlock('resellerorder/index'))
      ->renderLayout();

  }

  public function editAction()
  {

    $this->loadLayout();
    $this->_addContent($this->getLayout()->createBlock('resellerorder/admin_edit'));
    $this->renderLayout();

  }

  public function saveAction()
  {

    $resellerOrderId = $this->getRequest()->getParam('id', false);
    error_log($resellerOrderId);
    if ($data = $this->getRequest()->getPost()) {
       $resellerOrder = Mage::getModel('resellerorder/resellerorder')->load($resellerOrderId)->addData($data);
       try {
           $resellerOrder->setId($resellerOrderId)->save();
           $resellerOrder->save();
           Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('resellerorder')->__('Reseller
               Order was saved successfully'));
           $this->getResponse()->setRedirect($this->getUrl('*/*/'));
           return;
       } catch (Exception $e) {
           Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
       }

    }


  }

  public function deleteAction()
  {

    $resellerOrderId = $this->getRequest()->getParam('id', false);

    try {
        Mage::getModel('resellerorder/resellerorder')->setId($resellerOrderId)->delete();
        Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('resellerorder')->__('Reseller
            Order record deleted successfully.'));
        $this->getResponse()->setRedirect($this->getUrl('*/*/'));

        return;
    } catch (Exception $e) {
      Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
    }

    $this->_redirectReferer();

  }

}
