<?php

class Accelereyes_Qla_Block_Admin_Main_Grid extends Mage_Adminhtml_Block_Widget_Grid
{

  public function __construct()
  {
    parent::__construct();
    $this->setId('qlaGrid');
    $this->setUseAjax(true);
    $this->setDefaultSort('id');
    $this->setDefaultDir('DESC');
  }

  protected function _prepareCollection()
  {
    $resource = Mage::getSingleton('core/resource');
    $collection = Mage::getModel('qla/qla')->getCollection();
    $this->setCollection($collection);

    return parent::_prepareCollection();
  }

  protected function _prepareColumns()
  {
    $this->addColumn('id', array(
				 'header' => Mage::helper('qla')->__('ID'),
				 'align' => 'right',
				 'width' => '50px',
				 'filter_index' => 'id',
				 'index' => 'id',
				 'type' =>'number'
				 ));

    $this->addColumn('customer_id', array(
				 'header' => Mage::helper('qla')->__('Customer ID'),
				 'align' => 'right',
				 'width' => '50px',
				 'filter_index' => 'customer_id',
				 'index' => 'customer_id',
				 'type' =>'number'
				 ));

    $this->addColumn('date', array(
				 'header' => Mage::helper('qla')->__('Purchase Date'),
				 'align' => 'right',
				 'width' => '50px',
				 'filter_index' => 'date',
				 'index' => 'date',
				 'type' =>'number'
				 ));

    $this->addColumn('version', array(
				 'header' => Mage::helper('qla')->__('Version'),
				 'align' => 'right',
				 'width' => '50px',
				 'filter_index' => 'version',
				 'index' => 'version',
				 'type' =>'text'
				 ));

    $this->addColumn('matlab_license', array(
				 'header' => Mage::helper('qla')->__('MATLAB License'),
				 'align' => 'right',
				 'width' => '50px',
				 'filter_index' => 'matlab_license',
				 'index' => 'matlab_license',
				 'type' =>'text'
				 ));

    $this->addColumn('type', array(
				 'header' => Mage::helper('qla')->__('Type'),
				 'align' => 'right',
				 'width' => '50px',
				 'filter_index' => 'type',
				 'index' => 'type',
				 'type' =>'text'
				 ));



    return parent::_prepareColumns();
  }

  public function getRowUrl($row)
  {
    return $this->getUrl('*/*/edit', array(
					   'id' => $row->getId(),
					   ));
  }

}